/**
 * i-net software provides programming examples for illustration only, without warranty
 * either expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and/or fitness for a particular purpose. This programming example
 * assumes that you are familiar with the programming language being demonstrated and
 * the tools used to create and debug procedures. i-net software support professionals
 * can help explain the functionality of a particular procedure, but they will not modify
 * these examples to provide added functionality or construct procedures to meet your
 * specific needs.
 *
 * Copyright © 1999-2025 i-net software GmbH, Berlin, Germany.
**/
package rdc;

import java.io.File;
import java.net.URL;

import com.inet.report.DatabaseTables;
import com.inet.report.Engine;
import com.inet.report.RDC;

/**
 * This example shows how to load an existing report from file, save it in a modified rpt file and reload the modified
 * rpt file.
 */
public class ReportFromXmlFileSample extends RDCSample {

    /**
     * Creates a new engine for an existing rpt file, modify it, save it in a new rpt file and load it into a new
     * engine.
     * @param exportFmt the output format (e.g. Engine.EXPORT_PDF)
     * @return the new engine for the report
     */
    @Override
    public Engine createAndFillEngine( String exportFmt ) {

        //file, that is read
        String mainreport = "samples/rdc/complex.rpt";
        //file, that is written and read back
        String outputFileName = "complex-modified.rpt";

        Engine eng = null; //engine for the complex.rpt file
        Engine engNew = null; //engine for the modified rpt file

        try {
            //create new engine
            eng = new Engine( exportFmt );
            //if you don't have an i-net Clear Reports report file: load a rpt-file
            URL reportURL = getClass().getResource( '/' + mainreport );
            if( reportURL != null ) {
                eng.setReportFile( reportURL );
            } else {
                eng.setReportFile( mainreport );
            }

            //enable save password option (default: false) before saving            
            DatabaseTables dbConf = eng.getDatabaseTables();
            dbConf.setSavePassword( true );

            //save the engine (with data (i.e. from rpt-file) into rpt file
            //specify the engine for writing with second parameter
            RDC.saveEngine( new File( System.getProperty( "user.dir" ) + outputFileName ), eng );

            //read the data from rpt file
            //a newly created engine will be returned, initialized with data from rpt file
            engNew = RDC.loadEngine( new File( System.getProperty( "user.dir" ) + outputFileName ), exportFmt );

            //return one of both engines
            return engNew; //return the engine with data from the modified rpt file
        } catch( Exception e ) {
            e.printStackTrace();
            System.exit( 1 );
            return null;
        }
    }

    /**
     * Main method of this sample
     * @param args arguments not used
     */
    public static void main( String[] args ) {
        new ReportFromXmlFileSample().initUI();
    }
}
